height = 4096;
width = height*2;

A = imread('world_map_basic.jpg');
A = double(A)/255;
R = A(:,:,1);
G = A(:,:,2);
B = A(:,:,3);

latitude_gap = 10;
longitude_gap = 10;
linewidth = 1;

v1 = 0.9;
v2 = 0.9;

color1 = [v1,v1,v1];
color2 = [v2,v1,v1];
color3 = [v1,v2,v1];
color4 = [v2,v2,v1];
color5 = [v1,v1,v2];
color6 = [v2,v1,v2];
color7 = [v1,v2,v2];
color8 = [v2,v2,v2];
latitude_color = 0*[0.2,0.5,1];
longitude_color = 0*[1,0.5,0.2];

theta1d = linspace(-90,90,height);
phi1d = linspace(0,360,width);
[phi,theta] = meshgrid(phi1d,theta1d);

isLatitude = mod(theta+linewidth/2,latitude_gap)<=linewidth;
isLongitude= mod(phi+linewidth/2,longitude_gap)<=linewidth;

isRegion1 = theta>=0 & phi<90;
isRegion2 = theta>=0 & phi>=90 & phi<180;
isRegion3 = theta>=0 & phi>=180 & phi<270;
isRegion4 = theta>=0 & phi>=270;
isRegion5 = theta<0 & phi<90;
isRegion6 = theta<0 & phi>=90 & phi<180;
isRegion7 = theta<0 & phi>=180 & phi<270;
isRegion8 = theta<0 & phi>=270;

%R = zeros(height,width);
%G = R;
%B = R;

%{
R(isRegion1) = color1(1);
G(isRegion1) = color1(2);
B(isRegion1) = color1(3);
R(isRegion2) = color2(1);
G(isRegion2) = color2(2);
B(isRegion2) = color2(3);
R(isRegion3) = color3(1);
G(isRegion3) = color3(2);
B(isRegion3) = color3(3);
R(isRegion4) = color4(1);
G(isRegion4) = color4(2);
B(isRegion4) = color4(3);
R(isRegion5) = color5(1);
G(isRegion5) = color5(2);
B(isRegion5) = color5(3);
R(isRegion6) = color6(1);
G(isRegion6) = color6(2);
B(isRegion6) = color6(3);
R(isRegion7) = color7(1);
G(isRegion7) = color7(2);
B(isRegion7) = color7(3);
R(isRegion8) = color8(1);
G(isRegion8) = color8(2);
B(isRegion8) = color8(3);
%}

R(isLatitude) = latitude_color(1);
G(isLatitude) = latitude_color(2);
B(isLatitude) = latitude_color(3);

R(isLongitude)= longitude_color(1);
G(isLongitude)= longitude_color(2);
B(isLongitude)= longitude_color(3);
Image = cat(3,R,G,B);
imshow(Image);
